VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Using 24-bit Interval Counter of KPCI-3140"
   ClientHeight    =   3975
   ClientLeft      =   1950
   ClientTop       =   1875
   ClientWidth     =   6825
   LinkTopic       =   "Form1"
   ScaleHeight     =   3975
   ScaleWidth      =   6825
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   5160
      TabIndex        =   10
      Top             =   3360
      Width           =   975
   End
   Begin VB.TextBox txtStatus 
      Enabled         =   0   'False
      Height          =   285
      Left            =   720
      TabIndex        =   7
      Top             =   2880
      Width           =   4575
   End
   Begin VB.TextBox txtInterval 
      Height          =   285
      Left            =   5520
      TabIndex        =   5
      Text            =   "100"
      ToolTipText     =   "Can be no greater than 419 msec"
      Top             =   1680
      Width           =   615
   End
   Begin VB.ComboBox devNum 
      Height          =   315
      Left            =   3240
      TabIndex        =   4
      TabStop         =   0   'False
      Text            =   "0"
      Top             =   960
      Width           =   855
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop"
      Enabled         =   0   'False
      Height          =   375
      Left            =   720
      TabIndex        =   2
      Top             =   2280
      Width           =   2175
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start"
      Enabled         =   0   'False
      Height          =   375
      Left            =   720
      TabIndex        =   1
      Top             =   1680
      Width           =   2175
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Open Driver"
      Height          =   375
      Left            =   720
      TabIndex        =   0
      Top             =   960
      Width           =   2175
   End
   Begin DlsrLib.DriverLINXSR DriverLINXSR1 
      Left            =   5520
      Top             =   240
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label lblRate 
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   3240
      TabIndex        =   9
      Top             =   2160
      Width           =   3255
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Device Number:"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   165
      Left            =   3240
      TabIndex        =   8
      Top             =   600
      Width           =   1215
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Requested Interval (msec) :"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   165
      Left            =   3120
      TabIndex        =   6
      Top             =   1680
      Width           =   2100
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   360
      Left            =   480
      TabIndex        =   3
      Top             =   240
      Width           =   1845
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
' this example was written in VB6
' it was tested with a KPCI-3140 using the 3140-850A02 driver in Win2KSP1


Private Sub cmdInit_Click()
Dim DeviceNumber As Integer
DeviceNumber = CInt(devNum.Text)
With DriverLINXSR1
.Req_DLL_name = "kpci3140"
.Req_device = DeviceNumber
.Req_op = DL_INITIALIZE
.Req_mode = DL_OTHER
.Req_subsystem = DL_DEVICE
.Refresh
End With
If DriverLINXSR1.Res_result = DL_NoErr Then
cmdStart.Enabled = True
txtStatus.Text = DriverLINXSR1.Message
Else
txtStatus.Text = DriverLINXSR1.Message
End If
' set focus back to our form
Form1.SetFocus
End Sub

Private Sub cmdStart_Click()
Dim interval As Single
interval = CSng(txtInterval.Text) / 1000 ' convert to milli seconds
With DriverLINXSR1
.Req_op = DL_START
.Req_mode = DL_INTERRUPT   'this will be an interrupt-driven application
.Req_subsystem = DL_CT
.Evt_Tim_type = DL_RATEEVENT
.Evt_Str_type = DL_COMMAND
.Evt_Stp_type = DL_COMMAND
.Evt_Tim_rateChannel = 8   ' one of the 24bit interval timers that can
' be used for pacing
.Evt_Tim_rateClock = DL_INTERNAL1 '
.Evt_Tim_rateGate = DL_DISABLED
.Evt_Tim_rateMode = DL_RATEGEN     'Use the rate generator mode
' program the rate at which the counters will elapse......
.Evt_Tim_ratePeriod = .DLSecs2Tics(.Evt_Tim_rateChannel, interval)
lblRate.Caption = "Update Rate is : " & Str(1 / interval) & " Hz"
' internal1 timebase is 40MHz.  rateChannel 8 is a 24bit counter.
' 40MHz / 2^24 = 2.38 Hz => 419 msec is the slowest you can go.....
'
' how fast can you go?  how fast can TimerTic Windows' messages be processed?
' not practical to go faster than about 1KHz
.Evt_Tim_ratePulses = 0
.Evt_Tim_rateOnCount = 0
.Sel_chan_N = 0
.Sel_buf_N = 0

' display edit SR dialog from LearnDL application
'.Req_op_edit = True
'.Refresh
.Refresh
End With

If DriverLINXSR1.Res_result = DL_NoErr Then
cmdStop.Enabled = True
cmdStart.Enabled = False
txtStatus.Text = DriverLINXSR1.Message
Else
txtStatus.Text = DriverLINXSR1.Message
End If
End Sub

Private Sub cmdStop_Click()
With DriverLINXSR1
.Req_op = DL_STOP
.Refresh
End With
If DriverLINXSR1.Res_result = DL_NoErr Then
cmdStop.Enabled = False
cmdStart.Enabled = True
'txtStatus.Text = DriverLINXSR1.Message
Else
txtStatus.Text = DriverLINXSR1.Message
End If
End Sub

Private Sub DriverLINXSR1_TimerTic(task As Integer, device As Integer, subsystem As Integer, mode As Integer)
DoEvents  ' let other messages be processed
Static elapsedCounter As Single
elapsedCounter = elapsedCounter + 1
txtStatus.Text = "Timer has Elapsed : " & Str(elapsedCounter) & " times."
End Sub


Private Sub Form_Load()
' populate the drop down with legal device numbers
devNum.AddItem "0", 0
devNum.AddItem "1", 1
devNum.AddItem "2", 2
devNum.AddItem "3", 3
devNum.AddItem "4", 4
devNum.AddItem "5", 5
' set it to select device 0 by default
devNum.ListIndex = 0
End Sub

Private Sub cmdExit_Click()
' just in case, stop any task that could be active...
With DriverLINXSR1
.Req_op = DL_STOP
.Refresh
End With
' unload the driver
DriverLINXSR1.Req_DLL_name = ""
End  ' exit this program
End Sub
